/*
 * Decompiled with CFR 0.152.
 */
package com.zenavia.zenamod.client.update;

import com.zenavia.zenamod.client.update.ChangelogScroll;
import com.zenavia.zenamod.client.update.UpdateChecker;
import com.zenavia.zenamod.client.update.UpdateInfo;
import com.zenavia.zenamod.client.update.UpdatePrefs;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UpdatePromptScreen
extends class_437 {
    private static final int PANEL_W_DEFAULT = 420;
    private static final int PANEL_H_DEFAULT = 300;
    private static final int PAD = 12;
    private static final class_2960 ICON_TEX = class_2960.method_60655((String)"zenamod", (String)"icon.png");
    private final class_437 parent;
    private final Runnable onAcceptPlayAnyway;
    private final UpdateInfo info;
    private class_4286 dontRemindCheck;
    private ChangelogScroll changelog;
    private String downloadUrl;

    public UpdatePromptScreen(class_437 parent, UpdateInfo info, Runnable onAcceptPlayAnyway) {
        super((class_2561)class_2561.method_43470((String)"Zenavia Mod - Update"));
        this.parent = parent;
        this.info = info;
        this.onAcceptPlayAnyway = onAcceptPlayAnyway;
        this.downloadUrl = UpdateChecker.buildDownloadUrl(info);
    }

    protected void method_25426() {
        int panelW = Math.min(420, this.field_22789 - 24);
        int panelH = Math.min(300, this.field_22790 - 24);
        panelW = Math.max(panelW, 280);
        panelH = Math.max(panelH, 200);
        int panelX = (this.field_22789 - panelW) / 2;
        int panelY = (this.field_22790 - panelH) / 2;
        List<String> lines = this.info.ZenaModchangelog == null || this.info.ZenaModchangelog.isEmpty() ? List.of("No changelog provided.") : this.info.ZenaModchangelog;
        ArrayList<class_2561> bulletLines = new ArrayList<class_2561>();
        for (String s : lines) {
            bulletLines.add((class_2561)class_2561.method_43470((String)("\u2022 " + s)));
        }
        int textAreaTop = panelY + 12 + 48;
        int textAreaHeight = panelH - 60 - 72;
        textAreaHeight = Math.max(textAreaHeight, 64);
        this.changelog = new ChangelogScroll(panelX + 12, textAreaTop, panelW - 24, textAreaHeight, bulletLines);
        this.method_37063((class_364)this.changelog);
        int btnW = (panelW - 36) / 3;
        int btnY = panelY + panelH - 12 - 20;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Mettre \u00e0 jour"), b -> class_156.method_668().method_670(this.downloadUrl)).method_46434(panelX + 12, btnY, btnW, 20).method_46431());
        if (!this.info.ZenaModforcedupdate) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Jouer quand m\u00eame"), b -> {
                if (this.dontRemindCheck != null && this.dontRemindCheck.method_20372() && this.info.ZenaModVersion != null) {
                    UpdatePrefs p = UpdatePrefs.load();
                    p.ignore(this.info.ZenaModVersion);
                }
                this.onAcceptPlayAnyway.run();
            }).method_46434(panelX + 24 + btnW, btnY, btnW, 20).method_46431());
        } else {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Revenir"), b -> this.field_22787.execute(() -> this.field_22787.method_1507(this.parent))).method_46434(panelX + 24 + btnW, btnY, btnW, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copier le lien"), b -> this.field_22787.field_1774.method_1455(this.downloadUrl)).method_46434(panelX + 36 + btnW * 2, btnY, btnW, 20).method_46431());
        if (!this.info.ZenaModforcedupdate && this.info.ZenaModVersion != null) {
            UpdatePrefs p = UpdatePrefs.load();
            boolean prechecked = p.isIgnored(this.info.ZenaModVersion);
            this.dontRemindCheck = class_4286.method_54787((class_2561)class_2561.method_43470((String)("Ne plus me rappeler pour " + this.info.ZenaModVersion)), (class_327)this.field_22793).method_54789(panelX + 12, btnY - 22).method_54794(prechecked).method_54788();
            this.method_37063((class_364)this.dontRemindCheck);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Retour"), b -> this.field_22787.execute(() -> this.field_22787.method_1507(this.parent))).method_46434(panelX + panelW - 12 - 60, panelY + 12, 60, 20).method_46431());
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -536870912);
        int panelW = Math.min(420, this.field_22789 - 24);
        int panelH = Math.min(300, this.field_22790 - 24);
        panelW = Math.max(panelW, 280);
        panelH = Math.max(panelH, 200);
        int panelX = (this.field_22789 - panelW) / 2;
        int panelY = (this.field_22790 - panelH) / 2;
        this.drawPanelShadow(ctx, panelX, panelY, panelW, panelH);
        ctx.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -267053800);
        int border = -14013135;
        ctx.method_25294(panelX, panelY, panelX + panelW, panelY + 1, border);
        ctx.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, border);
        ctx.method_25294(panelX, panelY, panelX + 1, panelY + panelH, border);
        ctx.method_25294(panelX + panelW - 1, panelY, panelX + panelW, panelY + panelH, border);
        try {
            ctx.method_25290(class_10799.field_56883, ICON_TEX, panelX + 12, panelY + 12, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String title = "Zenavia Mod " + this.info.ZenaModVersion + " disponible";
        ctx.method_51433(this.field_22793, title, panelX + 12 + 40, panelY + 12 + 4, 0xFFFFFF, true);
        String subtitle = this.info.ZenaModforcedupdate ? "Mise \u00e0 jour requise" : "Mise \u00e0 jour disponible";
        ctx.method_51433(this.field_22793, subtitle, panelX + 12 + 40, panelY + 12 + 18, 10405631, false);
        ctx.method_51433(this.field_22793, "Changelog", panelX + 12, panelY + 12 + 40, 0xC0C0C0, false);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private void drawPanelShadow(class_332 ctx, int x, int y, int w, int h) {
        int shadow = 0x60000000;
        ctx.method_25294(x - 3, y - 3, x + w + 3, y - 2, shadow);
        ctx.method_25294(x - 3, y + h + 2, x + w + 3, y + h + 3, shadow);
        ctx.method_25294(x - 3, y - 2, x - 2, y + h + 2, shadow);
        ctx.method_25294(x + w + 2, y - 2, x + w + 3, y + h + 2, shadow);
    }

    public void method_25410(class_310 client, int width, int height) {
        class_437 parentBackup = this.parent;
        UpdateInfo infoBackup = this.info;
        Runnable onAcceptBackup = this.onAcceptPlayAnyway;
        String dl = this.downloadUrl;
        client.method_1507((class_437)new UpdatePromptScreen(parentBackup, infoBackup, onAcceptBackup));
    }
}

