/*
 * Decompiled with CFR 0.152.
 */
package com.zenavia.zenamod.client.update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public final class UpdatePrefs {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "zenavia_update_prefs.json";
    public String ignoredVersion = null;

    public static UpdatePrefs load() {
        block8: {
            UpdatePrefs updatePrefs;
            block9: {
                Path cfgDir = FabricLoader.getInstance().getConfigDir();
                Path file = cfgDir.resolve(FILE_NAME);
                if (!Files.exists(file, new LinkOption[0])) break block8;
                BufferedReader r = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                try {
                    UpdatePrefs p = (UpdatePrefs)GSON.fromJson((Reader)r, UpdatePrefs.class);
                    UpdatePrefs updatePrefs2 = updatePrefs = p != null ? p : new UpdatePrefs();
                    if (r == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                ((Reader)r).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((Reader)r).close();
            }
            return updatePrefs;
        }
        return new UpdatePrefs();
    }

    public void save() {
        try {
            Path cfgDir = FabricLoader.getInstance().getConfigDir();
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path file = cfgDir.resolve(FILE_NAME);
            try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isIgnored(String version) {
        return version != null && version.equals(this.ignoredVersion);
    }

    public void ignore(String version) {
        this.ignoredVersion = version;
        this.save();
    }

    public void clear() {
        this.ignoredVersion = null;
        this.save();
    }
}

