/*
 * Decompiled with CFR 0.152.
 */
package com.zenavia.zenamod.client.update;

import com.google.gson.Gson;
import com.zenavia.zenamod.client.ZenamodClient;
import com.zenavia.zenamod.client.update.SemVer;
import com.zenavia.zenamod.client.update.UpdateInfo;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class UpdateChecker {
    private static final String JSON_URL = "https://zenavia.net/files/spigotupdate.json";
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Gson GSON = new Gson();
    private static volatile UpdateInfo cached;
    private static volatile long cachedAtMs;
    private static final long CACHE_MS = 300000L;

    public static void prewarm() {
    }

    public static UpdateInfo fetchUpdateInfo() {
        long now = System.currentTimeMillis();
        if (cached != null && now - cachedAtMs < 300000L) {
            return cached;
        }
        try {
            HttpRequest req = HttpRequest.newBuilder(URI.create(JSON_URL)).timeout(Duration.ofSeconds(5L)).header("Accept", "application/json").GET().build();
            HttpResponse<String> resp = CLIENT.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                UpdateInfo info;
                cached = info = (UpdateInfo)GSON.fromJson(resp.body(), UpdateInfo.class);
                cachedAtMs = now;
                return info;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean shouldPrompt(UpdateInfo info) {
        if (info == null) {
            return false;
        }
        if (info.ZenaModVersion == null) {
            return false;
        }
        return SemVer.isRemoteNewer(ZenamodClient.CURRENT_VERSION, info.ZenaModVersion);
    }

    public static String buildDownloadUrl(UpdateInfo info) {
        String v = info != null && info.ZenaModVersion != null ? info.ZenaModVersion : "latest";
        return "https://zenavia.net/files/zenamod-" + v + ".jar";
    }

    static {
        cachedAtMs = 0L;
    }
}

